/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.storage;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.party.PartyPosition;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.client.storage.ClientPC;
import com.cobblemon.mod.common.client.storage.ClientParty;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\u0003J\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010 \u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0004\b \u0010\fJ\u001d\u0010!\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0004\b!\u0010\"J%\u0010$\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u0019\u00a2\u0006\u0004\b$\u0010%J%\u0010(\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t\u00a2\u0006\u0004\b(\u0010)J%\u0010*\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t\u00a2\u0006\u0004\b*\u0010)J%\u0010+\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u001d\u00a2\u0006\u0004\b+\u0010,J\u001d\u0010-\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0004\b-\u0010\"J'\u00101\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010.\u001a\u00020\u00152\b\u00100\u001a\u0004\u0018\u00010/\u00a2\u0006\u0004\b1\u00102J%\u00105\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010.\u001a\u00020\u00152\u0006\u00104\u001a\u000203\u00a2\u0006\u0004\b5\u00106J\r\u00107\u001a\u00020\u0006\u00a2\u0006\u0004\b7\u0010\u0003J\r\u00108\u001a\u00020\u0006\u00a2\u0006\u0004\b8\u0010\u0003R\"\u0010:\u001a\u0002098\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R#\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002090@8\u0006\u00a2\u0006\f\n\u0004\bA\u0010B\u001a\u0004\bC\u0010DR#\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020E0@8\u0006\u00a2\u0006\f\n\u0004\bF\u0010B\u001a\u0004\bG\u0010DR\"\u0010H\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u0018\u0010N\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bN\u0010O\u00a8\u0006P"}, d2={"Lcom/cobblemon/mod/common/client/storage/ClientStorageManager;", "", "<init>", "()V", "", "forward", "", "shiftSelected", "(Z)V", "Ljava/util/UUID;", "pokemon", "switchToPokemon", "(Ljava/util/UUID;)V", "checkSelectedPokemon", "storeID", "pokemonID", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "locatePokemon", "(Ljava/util/UUID;Ljava/util/UUID;)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "mine", "uuid", "", "slots", "createParty", "(ZLjava/util/UUID;I)V", "Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;", "position", "setPartyPokemon", "(Ljava/util/UUID;Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "setPCPokemon", "(Ljava/util/UUID;Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "setPartyStore", "removeFromParty", "(Ljava/util/UUID;Ljava/util/UUID;)V", "newPosition", "moveInParty", "(Ljava/util/UUID;Ljava/util/UUID;Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;)V", "pokemonID1", "pokemonID2", "swapInParty", "(Ljava/util/UUID;Ljava/util/UUID;Ljava/util/UUID;)V", "swapInPC", "moveInPC", "(Ljava/util/UUID;Ljava/util/UUID;Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;)V", "removeFromPC", "boxNumber", "", "name", "renameBox", "(Ljava/util/UUID;ILjava/lang/String;)V", "Lnet/minecraft/class_2960;", "wallpaper", "changeBoxWallpaper", "(Ljava/util/UUID;ILnet/minecraft/class_2960;)V", "onLogin", "onLogout", "Lcom/cobblemon/mod/common/client/storage/ClientParty;", "party", "Lcom/cobblemon/mod/common/client/storage/ClientParty;", "getParty", "()Lcom/cobblemon/mod/common/client/storage/ClientParty;", "setParty", "(Lcom/cobblemon/mod/common/client/storage/ClientParty;)V", "", "partyStores", "Ljava/util/Map;", "getPartyStores", "()Ljava/util/Map;", "Lcom/cobblemon/mod/common/client/storage/ClientPC;", "pcStores", "getPcStores", "selectedSlot", "I", "getSelectedSlot", "()I", "setSelectedSlot", "(I)V", "selectedPokemon", "Ljava/util/UUID;", "common"})
@SourceDebugExtension(value={"SMAP\nClientStorageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientStorageManager.kt\ncom/cobblemon/mod/common/client/storage/ClientStorageManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1761#2,3:165\n295#2,2:168\n*S KotlinDebug\n*F\n+ 1 ClientStorageManager.kt\ncom/cobblemon/mod/common/client/storage/ClientStorageManager\n*L\n34#1:165,3\n64#1:168,2\n*E\n"})
public final class ClientStorageManager {
    @NotNull
    private ClientParty party;
    @NotNull
    private final Map<UUID, ClientParty> partyStores;
    @NotNull
    private final Map<UUID, ClientPC> pcStores;
    private int selectedSlot;
    @Nullable
    private UUID selectedPokemon;

    public ClientStorageManager() {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.party = new ClientParty(uUID, 1);
        this.partyStores = new LinkedHashMap();
        this.pcStores = new LinkedHashMap();
        this.selectedSlot = -1;
    }

    @NotNull
    public final ClientParty getParty() {
        return this.party;
    }

    public final void setParty(@NotNull ClientParty clientParty) {
        Intrinsics.checkNotNullParameter((Object)clientParty, (String)"<set-?>");
        this.party = clientParty;
    }

    @NotNull
    public final Map<UUID, ClientParty> getPartyStores() {
        return this.partyStores;
    }

    @NotNull
    public final Map<UUID, ClientPC> getPcStores() {
        return this.pcStores;
    }

    public final int getSelectedSlot() {
        return this.selectedSlot;
    }

    public final void setSelectedSlot(int n) {
        this.selectedSlot = n;
    }

    public final void shiftSelected(boolean forward) {
        boolean partyHasSome;
        block10: {
            Iterable $this$any$iv = this.party.getSlots();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pokemon it = (Pokemon)element$iv;
                    boolean bl = false;
                    if (!(it != null)) continue;
                    v0 = true;
                    break block10;
                }
                v0 = partyHasSome = false;
            }
        }
        if (!partyHasSome) {
            this.selectedSlot = 0;
            this.selectedPokemon = null;
            return;
        }
        this.selectedSlot += forward ? 1 : -1;
        if (this.selectedSlot >= this.party.getSlots().size()) {
            this.selectedSlot = -1;
            this.shiftSelected(forward);
        } else if (this.selectedSlot < 0) {
            this.selectedSlot = this.party.getSlots().size();
            this.shiftSelected(forward);
        } else if (this.party.get(this.selectedSlot) == null) {
            this.shiftSelected(forward);
        } else {
            Pokemon pokemon = this.party.get(this.selectedSlot);
            this.selectedPokemon = pokemon != null ? pokemon.getUuid() : null;
        }
    }

    public final void switchToPokemon(@NotNull UUID pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        this.selectedPokemon = pokemon;
        this.selectedSlot = CollectionsKt.indexOf((Iterable)this.party, (Object)this.party.findByUUID(pokemon));
        this.checkSelectedPokemon();
    }

    /*
     * WARNING - void declaration
     */
    public final void checkSelectedPokemon() {
        if (this.selectedSlot == -1) {
            Object v0;
            block12: {
                Iterable $this$firstOrNull$iv = this.party;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Pokemon it = (Pokemon)element$iv;
                    boolean bl = false;
                    if (!(it != null)) continue;
                    v0 = element$iv;
                    break block12;
                }
                v0 = null;
            }
            Pokemon pokemon = v0;
            if (pokemon == null) {
                return;
            }
            Pokemon pokemon2 = pokemon;
            this.selectedSlot = this.party.getSlots().indexOf(pokemon2);
            this.selectedPokemon = pokemon2.getUuid();
        } else if (this.selectedPokemon == null) {
            ClientStorageManager clientStorageManager = this;
            Object object = this.party.get(new PartyPosition(this.selectedSlot));
            if (object == null || (object = ((Pokemon)object).getUuid()) == null) {
                void $this$checkSelectedPokemon_u24lambda_u241;
                ClientStorageManager $i$f$firstOrNull = this;
                ClientStorageManager clientStorageManager2 = clientStorageManager;
                boolean bl = false;
                $this$checkSelectedPokemon_u24lambda_u241.selectedSlot = -1;
                $this$checkSelectedPokemon_u24lambda_u241.checkSelectedPokemon();
                object = null;
                clientStorageManager = clientStorageManager2;
            }
            clientStorageManager.selectedPokemon = object;
        } else {
            UUID uUID = this.selectedPokemon;
            Intrinsics.checkNotNull((Object)uUID);
            if (this.party.getPosition(uUID) != this.selectedSlot) {
                UUID uUID2 = this.selectedPokemon;
                Intrinsics.checkNotNull((Object)uUID2);
                int foundSlot = this.party.getPosition(uUID2);
                if (foundSlot != -1) {
                    this.selectedSlot = foundSlot;
                } else {
                    this.selectedPokemon = null;
                    this.checkSelectedPokemon();
                }
            } else if (this.selectedSlot >= this.party.getSlots().size()) {
                this.selectedSlot = -1;
                this.checkSelectedPokemon();
            }
        }
    }

    @Nullable
    public final Pokemon locatePokemon(@NotNull UUID storeID, @NotNull UUID pokemonID) {
        Intrinsics.checkNotNullParameter((Object)storeID, (String)"storeID");
        Intrinsics.checkNotNullParameter((Object)pokemonID, (String)"pokemonID");
        Object object = this.partyStores.get(storeID);
        if (object == null || (object = ((ClientParty)object).findByUUID(pokemonID)) == null) {
            ClientPC clientPC = this.pcStores.get(storeID);
            object = clientPC != null ? clientPC.findByUUID(pokemonID) : null;
        }
        return object;
    }

    public final void createParty(boolean mine, @NotNull UUID uuid, int slots) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        ClientParty party = new ClientParty(uuid, slots);
        this.partyStores.put(uuid, party);
        if (mine) {
            this.party = party;
            this.checkSelectedPokemon();
        }
    }

    public final void setPartyPokemon(@NotNull UUID storeID, @NotNull PartyPosition position, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)storeID, (String)"storeID");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        ClientParty clientParty = this.partyStores.get(storeID);
        if (clientParty == null) {
            Cobblemon.LOGGER.error("Tried setting a Pok\u00e9mon in position " + position + " for party store " + storeID + " but no such store found.");
            return;
        }
        ClientParty party = clientParty;
        party.set(position, pokemon);
        this.checkSelectedPokemon();
    }

    public final void setPCPokemon(@NotNull UUID storeID, @NotNull PCPosition position, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)storeID, (String)"storeID");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        ClientPC clientPC = this.pcStores.get(storeID);
        if (clientPC == null) {
            Cobblemon.LOGGER.error("Tried setting a Pok\u00e9mon in position " + position + " for PC store " + storeID + " but no such store found.");
            return;
        }
        ClientPC pc = clientPC;
        pc.set(position, pokemon);
    }

    public final void setPartyStore(@NotNull UUID storeID) {
        Intrinsics.checkNotNullParameter((Object)storeID, (String)"storeID");
        ClientParty clientParty = this.partyStores.get(storeID);
        if (clientParty == null) {
            throw new IllegalArgumentException("Was told to set party store to " + storeID + " but no such store is known!");
        }
        this.party = clientParty;
        this.checkSelectedPokemon();
    }

    public final void removeFromParty(@NotNull UUID storeID, @NotNull UUID pokemonID) {
        Intrinsics.checkNotNullParameter((Object)storeID, (String)"storeID");
        Intrinsics.checkNotNullParameter((Object)pokemonID, (String)"pokemonID");
        ClientParty clientParty = this.partyStores.get(storeID);
        if (clientParty != null) {
            clientParty.remove(pokemonID);
        }
        this.checkSelectedPokemon();
    }

    public final void moveInParty(@NotNull UUID storeID, @NotNull UUID pokemonID, @NotNull PartyPosition newPosition) {
        Intrinsics.checkNotNullParameter((Object)storeID, (String)"storeID");
        Intrinsics.checkNotNullParameter((Object)pokemonID, (String)"pokemonID");
        Intrinsics.checkNotNullParameter((Object)newPosition, (String)"newPosition");
        ClientParty clientParty = this.partyStores.get(storeID);
        if (clientParty != null) {
            clientParty.move(pokemonID, (StorePosition)newPosition);
        }
        this.checkSelectedPokemon();
    }

    public final void swapInParty(@NotNull UUID storeID, @NotNull UUID pokemonID1, @NotNull UUID pokemonID2) {
        Intrinsics.checkNotNullParameter((Object)storeID, (String)"storeID");
        Intrinsics.checkNotNullParameter((Object)pokemonID1, (String)"pokemonID1");
        Intrinsics.checkNotNullParameter((Object)pokemonID2, (String)"pokemonID2");
        ClientParty clientParty = this.partyStores.get(storeID);
        if (clientParty != null) {
            clientParty.swap(pokemonID1, pokemonID2);
        }
        this.checkSelectedPokemon();
    }

    public final void swapInPC(@NotNull UUID storeID, @NotNull UUID pokemonID1, @NotNull UUID pokemonID2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)storeID, (String)"storeID");
            Intrinsics.checkNotNullParameter((Object)pokemonID1, (String)"pokemonID1");
            Intrinsics.checkNotNullParameter((Object)pokemonID2, (String)"pokemonID2");
            ClientPC clientPC = this.pcStores.get(storeID);
            if (clientPC == null) break block0;
            clientPC.swap(pokemonID1, pokemonID2);
        }
    }

    public final void moveInPC(@NotNull UUID storeID, @NotNull UUID pokemonID, @NotNull PCPosition newPosition) {
        Intrinsics.checkNotNullParameter((Object)storeID, (String)"storeID");
        Intrinsics.checkNotNullParameter((Object)pokemonID, (String)"pokemonID");
        Intrinsics.checkNotNullParameter((Object)newPosition, (String)"newPosition");
        ClientPC clientPC = this.pcStores.get(storeID);
        if (clientPC != null) {
            clientPC.move(pokemonID, (StorePosition)newPosition);
        }
        this.checkSelectedPokemon();
    }

    public final void removeFromPC(@NotNull UUID storeID, @NotNull UUID pokemonID) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)storeID, (String)"storeID");
            Intrinsics.checkNotNullParameter((Object)pokemonID, (String)"pokemonID");
            ClientPC clientPC = this.pcStores.get(storeID);
            if (clientPC == null) break block0;
            clientPC.remove(pokemonID);
        }
    }

    public final void renameBox(@NotNull UUID storeID, int boxNumber, @Nullable String name) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)storeID, (String)"storeID");
            ClientPC clientPC = this.pcStores.get(storeID);
            if (clientPC == null) break block0;
            clientPC.renameBox(boxNumber, name);
        }
    }

    public final void changeBoxWallpaper(@NotNull UUID storeID, int boxNumber, @NotNull class_2960 wallpaper) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)storeID, (String)"storeID");
            Intrinsics.checkNotNullParameter((Object)wallpaper, (String)"wallpaper");
            ClientPC clientPC = this.pcStores.get(storeID);
            if (clientPC == null) break block0;
            clientPC.changeBoxWallpaper(boxNumber, wallpaper);
        }
    }

    public final void onLogin() {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.party = new ClientParty(uUID, 1);
        this.checkSelectedPokemon();
    }

    public final void onLogout() {
        this.partyStores.clear();
        this.pcStores.clear();
    }
}

